<?php
/* --------------------------------------------------------------
 ShippingDestination.php 2020-01-17
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 17 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

declare(strict_types=1);

namespace Gambio\Core\Configuration\Types;

use Gambio\Core\Configuration\Models\Read\Collections\Options;
use Gambio\Core\Configuration\Repositories\Components\OptionsResolver;

/**
 * Class ShippingDestination
 * @package Gambio\Core\Configuration\Types
 */
class ShippingDestination implements ConfigurationType
{
    /**
     * @inheritDoc
     */
    public function toOptions(OptionsResolver $resolver, string $value = null): ?Options
    {
        $data = [
            [
                'value' => 'national',
                'text'  => 'national',
            ],
            [
                'value' => 'international',
                'text'  => 'international',
            ],
            [
                'value' => 'both',
                'text'  => 'both',
            ],
        ];
        
        return Options::fromArray($data);
    }
    
    
    /**
     * @inheritDoc
     */
    public function inputType(): string
    {
        return 'dropdown';
    }
}